# ####################################
# SpeechUT Base model #
# ####################################
export CUDA_VISIBLE_DEVICES=0
CODE_ROOT=/data0/SpeechUT
max_tokens=800000
DATA_DIR=/data0/SpeechUT/dataset/MuSTC/en_de
MODEL_DIR=/data0/SpeechUT/finetune_mustc/en_de
lang=de
JOB=job25
#path=/data0/SpeechUT/finetune_mustc/en_de/${JOB}/checkpoint.avgnbest_bleu.pt
path=/data0/SpeechUT/finetune_mustc/en_de/${JOB}/checkpoint_last.pt
#path=/data0/SpeechUT/finetune_mustc/en_de/${JOB}/checkpoint_best.pt
#path=/data0/SpeechUT/finetune_mustc/en_de/checkpoint.avgnbest_bleu.pt
#results_path=/data0/SpeechUT/model/${JOB}
results_path=/data0/SpeechUT/finetune_mustc/en_de/${JOB}
python $CODE_ROOT/fairseq/fairseq_cli/generate.py $DATA_DIR \
    --gen-subset tst-COMMON_st \
    --max-tokens 2000000 \
    --max-source-positions 2000000 \
    --num-workers 0 \
    --user-dir $CODE_ROOT/speechut \
    --task speech_to_text \
    --config-yaml config_en${lang}.yaml \
    --path ${path} \
    --results-path ${results_path} \
    --scoring sacrebleu --max-len-a 0 --max-len-b 512 \
    --beam 10 \
    --lenpen "1.0" \


echo $results_path
tail -n 1 $results_path/generate-*.txt
#rm $results_path/generate-*.txt
#sleep 1s
rm $results_path/generate-*.txt
